/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWSecurityList;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class VWCachedSecurityList {
    private static final int BLOCK_SIZE = 1000;
    private static Hashtable m_users = new Hashtable();
    private static Hashtable m_usersParticipant = new Hashtable();
    private static Hashtable m_usersAndGroups = new Hashtable();
    private static Hashtable m_usersAndGroupsParticipant = new Hashtable();
    private static Hashtable m_groups = new Hashtable();
    private static Hashtable m_groupsParticipant = new Hashtable();
    private static long m_timeStamp = 0L;

    public static String[] getUsers(VWSession vwSession) throws Exception {
        return VWCachedSecurityList.getUsers(vwSession, -1L);
    }

    public static synchronized String[] getUsers(VWSession vwSession, long refreshInterval) throws Exception {
        try {
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            boolean bRefresh = false;
            long curTime = new Date().getTime();
            if (refreshInterval == 0L) {
                bRefresh = true;
            } else if (refreshInterval > 0L && m_timeStamp + refreshInterval * 3600000L <= curTime) {
                bRefresh = true;
            }
            Object[] users = null;
            if (bRefresh || !m_users.containsKey(routerURL)) {
                Vector<String> uppers = new Vector<String>();
                VWSecurityList userList = null;
                String userName = null;
                userList = vwSession.fetchUsers(1000, false);
                while (userList.hasNext()) {
                    userName = (String)userList.next();
                    uppers.add(userName);
                }
                users = new String[uppers.size()];
                uppers.copyInto(users);
                VWQubbleSort.sort(users);
                m_users.put(routerURL, users);
                m_timeStamp = curTime;
            } else {
                users = (String[])m_users.get(routerURL);
            }
            if (users != null && users.length > 0) {
                String[] userNames = new String[users.length];
                System.arraycopy(users, 0, userNames, 0, users.length);
                return userNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static synchronized VWParticipantItem[] getUsersParticipant(VWSession vwSession) throws Exception {
        try {
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            Object[] usersParticipant = null;
            if (!m_usersParticipant.containsKey(routerURL)) {
                VWParticipantList userList = vwSession.fetchUsersPx(1000, false);
                if (userList != null) {
                    Vector<VWParticipantItem> tmpList = new Vector<VWParticipantItem>();
                    while (userList.hasNext()) {
                        tmpList.addElement(new VWParticipantItem((VWParticipant)userList.next()));
                    }
                    if (tmpList != null && tmpList.size() > 0) {
                        usersParticipant = new VWParticipantItem[tmpList.size()];
                        tmpList.copyInto(usersParticipant);
                        VWQubbleSort.sort(usersParticipant);
                        m_usersParticipant.put(routerURL, usersParticipant);
                    }
                }
            } else {
                usersParticipant = (VWParticipantItem[])m_usersParticipant.get(routerURL);
            }
            if (usersParticipant != null && usersParticipant.length > 0) {
                VWParticipantItem[] participantItems = new VWParticipantItem[usersParticipant.length];
                System.arraycopy(usersParticipant, 0, participantItems, 0, usersParticipant.length);
                return participantItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static String[] getGroups(VWSession vwSession) throws Exception {
        return VWCachedSecurityList.getGroups(vwSession, -1L);
    }

    public static synchronized String[] getGroups(VWSession vwSession, long refreshInterval) throws Exception {
        try {
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            boolean bRefresh = false;
            long curTime = new Date().getTime();
            if (refreshInterval == 0L) {
                bRefresh = true;
            } else if (refreshInterval > 0L && m_timeStamp + refreshInterval * 3600000L <= curTime) {
                bRefresh = true;
            }
            Object[] groups = null;
            if (bRefresh || !m_groups.containsKey(routerURL)) {
                Vector<String> uppers = new Vector<String>();
                VWSecurityList groupList = null;
                String groupName = null;
                groupList = vwSession.fetchUserGroups(1000);
                while (groupList.hasNext()) {
                    groupName = (String)groupList.next();
                    uppers.add(groupName);
                }
                if (!uppers.isEmpty() && ((String)uppers.get(0)).equals("(NONE)")) {
                    uppers.remove(0);
                }
                groups = new String[uppers.size()];
                uppers.copyInto(groups);
                VWQubbleSort.sort(groups);
                m_groups.put(routerURL, groups);
                m_timeStamp = curTime;
            } else {
                groups = (String[])m_groups.get(routerURL);
            }
            if (groups != null && groups.length > 0) {
                String[] groupNames = new String[groups.length];
                System.arraycopy(groups, 0, groupNames, 0, groups.length);
                return groupNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static synchronized VWParticipantItem[] getGroupsParticipant(VWSession vwSession) throws Exception {
        try {
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            Object[] groupsParticipant = null;
            if (!m_groupsParticipant.containsKey(routerURL)) {
                VWParticipantList groupList = vwSession.fetchUserGroupsPx(1000);
                if (groupList != null) {
                    Vector<VWParticipantItem> tmpList = new Vector<VWParticipantItem>();
                    while (groupList.hasNext()) {
                        tmpList.addElement(new VWParticipantItem((VWParticipant)groupList.next()));
                    }
                    if (tmpList != null && tmpList.size() > 0) {
                        groupsParticipant = new VWParticipantItem[tmpList.size()];
                        tmpList.copyInto(groupsParticipant);
                        VWQubbleSort.sort(groupsParticipant);
                        m_groupsParticipant.put(routerURL, groupsParticipant);
                    }
                }
            } else {
                groupsParticipant = (VWParticipantItem[])m_groupsParticipant.get(routerURL);
            }
            if (groupsParticipant != null && groupsParticipant.length > 0) {
                VWParticipantItem[] participantItems = new VWParticipantItem[groupsParticipant.length];
                System.arraycopy(groupsParticipant, 0, participantItems, 0, groupsParticipant.length);
                return participantItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static String[] getUsersAndGroups(VWSession vwSession) throws Exception {
        return VWCachedSecurityList.getUsersAndGroups(vwSession, -1L);
    }

    public static synchronized String[] getUsersAndGroups(VWSession vwSession, long refreshInterval) throws Exception {
        try {
            long curTime;
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            boolean bRefresh = false;
            if (refreshInterval == 0L) {
                bRefresh = true;
            } else if (refreshInterval > 0L && m_timeStamp + refreshInterval * 3600000L <= (curTime = new Date().getTime())) {
                bRefresh = true;
            }
            String[] usersAndGroups = null;
            if (bRefresh || !m_usersAndGroups.containsKey(routerURL)) {
                String[] users = VWCachedSecurityList.getUsers(vwSession, 0L);
                String[] groups = VWCachedSecurityList.getGroups(vwSession, 0L);
                usersAndGroups = new String[users.length + groups.length];
                usersAndGroups = VWCachedSecurityList.mergeUsersAndGroups(users, groups);
                m_usersAndGroups.put(routerURL, usersAndGroups);
            } else {
                usersAndGroups = (String[])m_usersAndGroups.get(routerURL);
            }
            if (usersAndGroups != null && usersAndGroups.length > 0) {
                String[] userAndGroupNames = new String[usersAndGroups.length];
                System.arraycopy(usersAndGroups, 0, userAndGroupNames, 0, usersAndGroups.length);
                return userAndGroupNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static synchronized VWParticipantItem[] getUsersAndGroupsParticipant(VWSession vwSession) throws Exception {
        try {
            if (vwSession == null) {
                return null;
            }
            String routerURL = vwSession.getRouterURL();
            VWParticipantItem[] usersAndGroups = null;
            if (!m_usersAndGroupsParticipant.containsKey(routerURL)) {
                VWParticipantItem[] users = VWCachedSecurityList.getUsersParticipant(vwSession);
                VWParticipantItem[] groups = VWCachedSecurityList.getGroupsParticipant(vwSession);
                usersAndGroups = new VWParticipantItem[users.length + groups.length];
                usersAndGroups = VWCachedSecurityList.mergeUsersAndGroupsParticipant(users, groups);
                m_usersAndGroupsParticipant.put(routerURL, usersAndGroups);
            } else {
                usersAndGroups = (VWParticipantItem[])m_usersAndGroupsParticipant.get(routerURL);
            }
            if (usersAndGroups != null && usersAndGroups.length > 0) {
                VWParticipantItem[] participantItems = new VWParticipantItem[usersAndGroups.length];
                System.arraycopy(usersAndGroups, 0, participantItems, 0, usersAndGroups.length);
                return participantItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return null;
    }

    public static synchronized void reset() {
        m_users.clear();
        m_groups.clear();
        m_usersAndGroups.clear();
        m_usersParticipant.clear();
        m_groupsParticipant.clear();
        m_usersAndGroupsParticipant.clear();
    }

    private static String[] mergeUsersAndGroups(String[] list1, String[] list2) {
        String[] combinedList = null;
        int combinedListSize = 0;
        int list1Size = 0;
        int list2Size = 0;
        int list1Index = 0;
        int list2Index = 0;
        String list1Item = null;
        String list2Item = null;
        try {
            list1Size = list1.length;
            list2Size = list2.length;
            combinedListSize = list1Size + list2Size;
            combinedList = new String[combinedListSize];
            for (int k = 0; k < combinedListSize; ++k) {
                if (list1Index >= list1Size) {
                    combinedList[k] = list2Item = list2[list2Index];
                    ++list2Index;
                    continue;
                }
                if (list2Index >= list2Size) {
                    combinedList[k] = list1Item = list1[list1Index];
                    ++list1Index;
                    continue;
                }
                list1Item = list1[list1Index];
                list2Item = list2[list2Index];
                if (VWStringUtils.compare(list1Item, list2Item) > 0) {
                    combinedList[k] = list2Item;
                    ++list2Index;
                    continue;
                }
                combinedList[k] = list1Item;
                ++list1Index;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return combinedList;
    }

    private static VWParticipantItem[] mergeUsersAndGroupsParticipant(VWParticipantItem[] list1, VWParticipantItem[] list2) {
        VWParticipantItem[] combinedList = null;
        int combinedListSize = 0;
        int list1Size = 0;
        int list2Size = 0;
        int list1Index = 0;
        int list2Index = 0;
        VWParticipantItem list1Item = null;
        VWParticipantItem list2Item = null;
        try {
            list1Size = list1.length;
            list2Size = list2.length;
            combinedListSize = list1Size + list2Size;
            combinedList = new VWParticipantItem[combinedListSize];
            for (int k = 0; k < combinedListSize; ++k) {
                if (list1Index >= list1Size) {
                    combinedList[k] = list2Item = list2[list2Index];
                    ++list2Index;
                    continue;
                }
                if (list2Index >= list2Size) {
                    combinedList[k] = list1Item = list1[list1Index];
                    ++list1Index;
                    continue;
                }
                list1Item = list1[list1Index];
                list2Item = list2[list2Index];
                if (VWStringUtils.compare(list1Item.getName(), list2Item.getName()) > 0) {
                    combinedList[k] = list2Item;
                    ++list2Index;
                    continue;
                }
                combinedList[k] = list1Item;
                ++list1Index;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return combinedList;
    }
}

